<?php $__env->startSection('content'); ?>
<!-- Hero Section -->
<div class="hero min-h-[60vh] bg-gradient-to-br from-blue-600 via-purple-600 to-indigo-800 relative overflow-hidden">
    <div class="hero-overlay bg-opacity-30"></div>
    <div class="hero-content text-center text-white relative z-10">
        <div class="max-w-4xl">
            <h1 class="mb-5 text-5xl font-bold leading-tight">
                🗳️ Pemilihan OSIS
                <span class="block text-3xl mt-2 text-blue-200">SMA NEGERI 1 CONTOH</span>
            </h1>
            <p class="mb-8 text-xl opacity-90 max-w-2xl mx-auto">
                Suaramu menentukan masa depan sekolah. Mari berpartisipasi dalam demokrasi siswa untuk memilih pemimpin terbaik!
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="<?php echo e(route('voter.login')); ?>" class="btn btn-primary btn-lg shadow-lg hover:shadow-xl transform hover:-translate-y-1 transition-all duration-300">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                    </svg>
                    Masuk Sebagai Pemilih
                </a>
                <button class="btn btn-outline btn-lg border-white text-white hover:bg-white hover:text-purple-600 shadow-lg hover:shadow-xl transform hover:-translate-y-1 transition-all duration-300" onclick="scrollToInfo()">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    Lihat Info Lengkap
                </button>
            </div>
        </div>
    </div>
    <!-- Animated Background Elements -->
    <div class="absolute top-10 left-10 w-20 h-20 bg-white opacity-10 rounded-full animate-pulse"></div>
    <div class="absolute bottom-20 right-20 w-16 h-16 bg-yellow-400 opacity-20 rounded-full animate-bounce"></div>
    <div class="absolute top-1/2 right-10 w-12 h-12 bg-pink-400 opacity-15 rounded-full animate-ping"></div>
</div>

<!-- Stats Section -->
<div class="py-16 bg-base-200">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-6 text-center">
            <div class="stat bg-white rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300">
                <div class="stat-figure text-primary">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                    </svg>
                </div>
                <div class="stat-title text-sm">Total Siswa</div>
                <div class="stat-value text-primary text-2xl">1,247</div>
            </div>
            
            <div class="stat bg-white rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300">
                <div class="stat-figure text-secondary">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
                <div class="stat-title text-sm">Kandidat</div>
                <div class="stat-value text-secondary text-2xl">5</div>
            </div>
            
            <div class="stat bg-white rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300">
                <div class="stat-figure text-accent">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
                <div class="stat-title text-sm">Hari Tersisa</div>
                <div class="stat-value text-accent text-2xl">3</div>
            </div>
            
            <div class="stat bg-white rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300">
                <div class="stat-figure text-success">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                    </svg>
                </div>
                <div class="stat-title text-sm">Partisipasi</div>
                <div class="stat-value text-success text-2xl">89%</div>
            </div>
        </div>
    </div>
</div>

<!-- Info Section -->
<div id="info-section" class="py-16">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <h2 class="text-4xl font-bold mb-4">Informasi Pemilihan</h2>
            <p class="text-lg opacity-70 max-w-2xl mx-auto">Segala hal yang perlu kamu ketahui tentang pemilihan OSIS tahun ini</p>
        </div>
        
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Cara Voting -->
            <div class="card bg-gradient-to-br from-blue-50 to-blue-100 border border-blue-200 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2">
                <div class="card-body">
                    <div class="flex items-center mb-4">
                        <div class="w-12 h-12 bg-blue-500 rounded-full flex items-center justify-center text-white mr-4">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <h3 class="card-title text-blue-800">Cara Voting</h3>
                    </div>
                    <div class="space-y-3">
                        <div class="flex items-start">
                            <span class="bg-blue-500 text-white rounded-full w-6 h-6 flex items-center justify-center text-sm mr-3 mt-0.5">1</span>
                            <p class="text-sm">Login menggunakan NIS dan PIN yang telah diberikan</p>
                        </div>
                        <div class="flex items-start">
                            <span class="bg-blue-500 text-white rounded-full w-6 h-6 flex items-center justify-center text-sm mr-3 mt-0.5">2</span>
                            <p class="text-sm">Pilih kandidat favoritmu dengan bijak</p>
                        </div>
                        <div class="flex items-start">
                            <span class="bg-blue-500 text-white rounded-full w-6 h-6 flex items-center justify-center text-sm mr-3 mt-0.5">3</span>
                            <p class="text-sm">Konfirmasi pilihan dan submit vote</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Timeline -->
            <div class="card bg-gradient-to-br from-purple-50 to-purple-100 border border-purple-200 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2">
                <div class="card-body">
                    <div class="flex items-center mb-4">
                        <div class="w-12 h-12 bg-purple-500 rounded-full flex items-center justify-center text-white mr-4">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                        </div>
                        <h3 class="card-title text-purple-800">Jadwal Penting</h3>
                    </div>
                    <div class="space-y-3">
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium">Kampanye</span>
                            <span class="badge badge-success">Berlangsung</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium">Pemungutan Suara</span>
                            <span class="badge badge-warning">19-20 Agu</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium">Pengumuman</span>
                            <span class="badge badge-outline">21 Agu</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pengumuman -->
            <div class="card bg-gradient-to-br from-green-50 to-green-100 border border-green-200 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2">
                <div class="card-body">
                    <div class="flex items-center mb-4">
                        <div class="w-12 h-12 bg-green-500 rounded-full flex items-center justify-center text-white mr-4">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z" />
                            </svg>
                        </div>
                        <h3 class="card-title text-green-800">Pengumuman</h3>
                    </div>
                    <div class="space-y-3">
                        <div class="alert alert-info py-2">
                            <svg xmlns="http://www.w3.org/2000/svg" class="stroke-current shrink-0 h-4 w-4" fill="none" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                            <span class="text-xs">Profil kandidat sudah tersedia di menu kampanye</span>
                        </div>
                        <div class="alert alert-success py-2">
                            <svg xmlns="http://www.w3.org/2000/svg" class="stroke-current shrink-0 h-4 w-4" fill="none" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                            <span class="text-xs">Sistem voting telah diuji dan siap digunakan</span>
                        </div>
                        <div class="alert alert-warning py-2">
                            <svg xmlns="http://www.w3.org/2000/svg" class="stroke-current shrink-0 h-4 w-4" fill="none" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.864-.833-2.634 0L3.178 16.5c-.77.833.192 2.5 1.732 2.5z"></path></svg>
                            <span class="text-xs">Jangan lupa bawa kartu pelajar saat voting</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- CTA Section -->
<div class="py-16 bg-gradient-to-r from-indigo-600 to-purple-600">
    <div class="container mx-auto px-4 text-center">
        <div class="max-w-3xl mx-auto text-white">
            <h2 class="text-3xl font-bold mb-4">Siap Untuk Memberikan Suara?</h2>
            <p class="text-xl mb-8 opacity-90">
                Partisipasi kamu sangat berarti untuk masa depan sekolah. Mari bersama-sama memilih pemimpin terbaik!
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="<?php echo e(route('voter.login')); ?>" class="btn btn-primary btn-lg bg-white text-purple-600 border-white hover:bg-gray-100 shadow-lg hover:shadow-xl transform hover:-translate-y-1 transition-all duration-300">
                    🗳️ Mulai Voting Sekarang
                </a>
                <a href="#" class="btn btn-outline btn-lg border-white text-white hover:bg-white hover:text-purple-600 shadow-lg hover:shadow-xl transform hover:-translate-y-1 transition-all duration-300">
                    📋 Lihat Kandidat
                </a>
            </div>
        </div>
    </div>
</div>

<script>
function scrollToInfo() {
    document.getElementById('info-section').scrollIntoView({ 
        behavior: 'smooth' 
    });
}
</script>

<style>
@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-10px); }
}

.animate-float {
    animation: float 3s ease-in-out infinite;
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\osis-vote\resources\views/welcome.blade.php ENDPATH**/ ?>