

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-br from-slate-50 to-slate-100 flex items-center justify-center p-4">
  <div id="toast-container" class="fixed top-5 right-5 z-50 space-y-2"></div>
  
  <div class="w-full max-w-md">
    <div class="text-center mb-8">
      
      <div class="inline-flex items-center justify-center w-12 h-12 bg-blue-600 rounded-xl mb-4">
        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>
      </div>
      
      <h1 class="text-2xl font-bold text-blue-600 mb-2">
        Login Pemilih
      </h1>
      <p class="text-slate-600 text-sm mb-4">Masuk untuk memberikan suara Anda</p>
      
      
      <div class="inline-block px-3 py-1 bg-yellow-100 rounded-full border border-yellow-200">
        <p class="text-yellow-800 text-sm">
          <span class="text-yellow-600">Periode:</span> 
          <span class="font-medium"><?php echo e($period->name ?? '—'); ?></span>
        </p>
      </div>
    </div>

    <div class="bg-white rounded-2xl border border-slate-200 shadow-sm p-8">
      <form method="POST" action="<?php echo e(route('voter.login.post')); ?>" class="space-y-6">
        <?php echo csrf_field(); ?>
        
        <div class="space-y-2">
          <label class="block text-slate-700 text-sm font-medium mb-2">
            Nomor Induk Siswa (NIS)
          </label>
          <input 
            name="nis" 
            type="text"
            placeholder="Masukkan NIS Anda"
            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-blue-600 focus:border-transparent transition-all duration-200"
            required
          >
          <?php $__errorArgs = ['nis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
            <div class="flex items-center gap-2 text-red-600 text-sm mt-2">
              <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
              </svg>
              <?php echo e($message); ?>

            </div>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="space-y-2">
          <label class="block text-slate-700 text-sm font-medium mb-2">
            PIN Keamanan
          </label>
          <input 
            name="pin" 
            type="password"
            placeholder="Masukkan PIN Anda"
            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-blue-600 focus:border-transparent transition-all duration-200"
            required
          >
          <?php $__errorArgs = ['pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
            <div class="flex items-center gap-2 text-red-600 text-sm mt-2">
              <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
              </svg>
              <?php echo e($message); ?>

            </div>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="pt-2">
          
          <button 
            type="submit" 
            class="w-full bg-blue-600 hover:bg-blue-700 text-white font-medium py-3 px-4 rounded-xl transition-colors duration-200 focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2"
          >
            Masuk
          </button>
        </div>
      </form>

      <div class="mt-6 pt-6 border-t border-slate-100">
        <p class="text-center text-slate-500 text-sm">
          Suara Anda rahasia dan terjamin keamanannya
        </p>
      </div>
    </div>
  </div>
</div>

<?php if(session()->has('status') || session()->has('error') || session()->has('info')): ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        let message = '';
        let type = '';
        let icon = '';
        
        <?php if(session()->has('status')): ?>
            message = "<?php echo e(session('status')); ?>";
            type = 'success';
            icon = `<svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg>`;
        <?php elseif(session()->has('error')): ?>
            message = "<?php echo e(session('error')); ?>";
            type = 'error';
            icon = `<svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/></svg>`;
        <?php elseif(session()->has('info')): ?>
            message = "<?php echo e(session('info')); ?>";
            type = 'info';
            icon = `<svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/></svg>`;
        <?php endif; ?>

        showModernToast(message, type, icon);
    });

    function showModernToast(message, type, icon) {
        const container = document.getElementById('toast-container');
        
        const typeClasses = {
            success: 'bg-white border-l-4 border-green-500 text-green-800 shadow-lg',
            error: 'bg-white border-l-4 border-red-500 text-red-800 shadow-lg',
            info: 'bg-white border-l-4 border-blue-500 text-blue-800 shadow-lg'
        };

        const iconColors = {
            success: 'text-green-500',
            error: 'text-red-500',
            info: 'text-blue-500'
        };

        const toast = document.createElement('div');
        toast.className = `
            ${typeClasses[type]} 
            p-4 rounded-lg transform transition-all duration-300 ease-in-out
            max-w-md border border-gray-100 animate-slide-in-right
        `;
        
        toast.innerHTML = `
            <div class="flex items-start">
                <div class="flex-shrink-0 ${iconColors[type]} mt-0.5">
                    ${icon}
                </div>
                <div class="ml-3 flex-1">
                    <p class="text-sm font-medium leading-5">${message}</p>
                </div>
                <div class="ml-4 flex-shrink-0 flex">
                    <button class="inline-flex text-gray-400 hover:text-gray-600 focus:outline-none transition ease-in-out duration-150" onclick="closeToast(this)">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                        </svg>
                    </button>
                </div>
            </div>
            <div class="mt-2 w-full bg-gray-200 rounded-full h-1">
                <div class="progress-bar h-full ${type === 'success' ? 'bg-green-500' : type === 'error' ? 'bg-red-500' : 'bg-blue-500'} rounded-full transition-all duration-5000 ease-linear" style="width: 100%"></div>
            </div>
        `;

        container.appendChild(toast);

        setTimeout(() => {
            const progressBar = toast.querySelector('.progress-bar');
            progressBar.style.width = '0%';
        }, 100);

        setTimeout(() => removeToast(toast), 5000);
    }

    function closeToast(button) {
        const toast = button.closest('.animate-slide-in-right');
        removeToast(toast);
    }

    function removeToast(toast) {
        toast.style.transform = 'translateX(100%)';
        toast.style.opacity = '0';
        setTimeout(() => {
            if (toast.parentNode) {
                toast.parentNode.removeChild(toast);
            }
        }, 300);
    }
</script>

<style>
    @keyframes slide-in-right {
        from {
            transform: translateX(100%);
            opacity: 0;
        }
        to {
            transform: translateX(0);
            opacity: 1;
        }
    }

    .animate-slide-in-right {
        animation: slide-in-right 0.3s ease-out;
    }

    .duration-5000 {
        transition-duration: 5000ms;
    }
</style>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.voter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\osis-vote\resources\views/voter/login.blade.php ENDPATH**/ ?>