<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\VoterAuthController;
// Kita akan konsisten menggunakan VoteController sesuai nama class di dalam file
use App\Http\Controllers\VoteController; 
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\CandidateController;
use App\Http\Controllers\Admin\PeriodController;
use App\Http\Controllers\Admin\VoterController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

Route::view('/', 'welcome');


// ----- PEMILIH -----
Route::get('/pemilih/login', [VoterAuthController::class, 'showLogin'])->name('voter.login');
Route::post('/pemilih/login', [VoterAuthController::class, 'login'])->name('voter.login.post');
Route::post('/logout', [VoterAuthController::class, 'logout'])->name('voter.logout');

// Halaman Voting (butuh login pemilih via middleware)
// Pastikan di app/Http/Kernel.php alias 'voter' menunjuk ke middleware yang benar
Route::middleware(['voter'])->group(function () {
    // Arahkan root setelah login ke halaman pemilihan
    Route::get('/vote', [VoteController::class, 'index'])->name('vote.home');
    Route::post('/vote/cast', [VoteController::class, 'store'])->name('vote.cast');
});
Route::get('/vote/thanks', [VoteController::class, 'thanks'])->name('vote.thanks');

// ----- ADMIN (auth default Laravel) -----
Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [\App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');
    Route::get('/dashboard/stats', [\App\Http\Controllers\Admin\DashboardController::class, 'getStatsJson'])->name('dashboard.stats');

    // Resources
    Route::resource('periods', PeriodController::class)->except(['show']);
    Route::resource('candidates', CandidateController::class)->except(['show']);
    
    // Voters
    Route::delete('voters/destroy-all', [VoterController::class, 'destroyAll'])->name('voters.destroyAll');
    Route::get('voters', [VoterController::class, 'index'])->name('voters.index');
    Route::post('voters/import', [VoterController::class, 'import'])->name('voters.import');
    Route::post('voters/generate-pins', [VoterController::class, 'generatePins'])->name('voters.generatePins');
    Route::get('voters/download-pins', [VoterController::class, 'downloadPins'])->name('voters.downloadPins');
    Route::get('voters/print-cards', [VoterController::class, 'printCards'])->name('voters.printCards');
    Route::get('voters/create', [VoterController::class, 'create'])->name('voters.create');
    Route::post('voters', [VoterController::class, 'store'])->name('voters.store');
    Route::get('voters/{voter}/edit', [VoterController::class, 'edit'])->name('voters.edit');
    Route::put('voters/{voter}', [VoterController::class, 'update'])->name('voters.update');
    Route::delete('voters/{voter}', [VoterController::class, 'destroy'])->name('voters.destroy');
    Route::post('voters/{voter}/generate-pin', [VoterController::class, 'generatePinForOne'])->name('voters.generatePinForOne');

});

// Auth routes (Breeze, etc.)
require __DIR__.'/auth.php';