@extends('layouts.app')
@section('content')
<h1 class="text-2xl font-bold mb-4">Bilik Suara — {{ $period->name }}</h1>

@if(session('error')) <div class="alert alert-error mb-3">{{ session('error') }}</div> @endif

@if(!$period->votingIsOpen())
<div class="alert alert-warning">Voting belum aktif.</div>
@else
<form method="POST" action="{{ route('voting.submit') }}" x-data="{selected:null}" class="grid md:grid-cols-3 gap-6">
    @csrf
    @foreach($candidates as $c)
    <label class="card bg-base-100 shadow cursor-pointer hover:shadow-lg transition">
        <input type="radio" name="candidate_id" value="{{ $c->id }}" class="hidden" x-model="selected">
        <figure class="aspect-[4/3] overflow-hidden">
            <img src="{{ $c->photoUrl() }}" alt="{{ $c->name }}" class="w-full h-full object-cover">
        </figure>
        <div class="card-body">
            <h3 class="card-title">{{ $c->number }}. {{ $c->name }}</h3>
            <p class="text-sm opacity-80">Kelas: {{ $c->class ?? '-' }}</p>
            <p class="text-sm line-clamp-3">{{ Str::limit($c->vision, 120) }}</p>
        </div>
    </label>
    @endforeach
    <div class="md:col-span-3">
        <div class="flex items-center gap-3">
            <a href="{{ route('voter.logout') }}" onclick="event.preventDefault(); this.nextElementSibling.submit();" class="btn">Keluar</a>
            <form method="POST" action="{{ route('voter.logout') }}">@csrf</form>
            <button class="btn btn-primary" onclick="return confirm('Yakin kirim suara? Anda tidak bisa mengubah pilihan.')" :disabled="!selected">Kirim Suara</button>
        </div>
    </div>
</form>
@endif
@endsection
