<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF--8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cetak Kartu Pemilih</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    TOKEN PEMILIH OSIS
    <style>
        /* * KITA PAKSA UKURAN KERTAS DAN MARGIN DARI CSS 
        */
        @page {
            size: A4 portrait; /* Tentukan ukuran kertas A4 */
            margin: 1cm;       /* Margin 1cm di semua sisi */
        }

        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;  /* Hapus margin/padding body */
            padding: 0; 
            background-color: #f4f4f4;
        }
        
        /* --- PERUBAHAN BESAR DI SINI --- */
        .page-container {
            /* Hapus semua sisa flexbox */
            
            /* Lebar A4 (210mm) - margin (2x10mm) = 190mm */
            width: 190mm; 
            margin: 0 auto; /* Pusatkan kontainer */
            
            /* Gunakan ini untuk menengahkan kartu-kartu */
            text-align: center; 
        }
        
        .card {
            width: 85mm; 
            height: 55mm;
            border: 1px dashed #999;
            padding: 15px;
            box-sizing: border-box;
            background-color: white;
            
            /* --- INI KUNCI UTAMA PERUBAHAN LAYOUT --- */
            
            /* 1. 'inline-flex' adalah kuncinya:
                'inline-' = Agar kartu bisa berbaris ke samping.
                'flex-'   = Agar layout internal kartu (header, body, pin) TIDAK RUSAK.
            */
            display: inline-flex; 
            
            flex-direction: column;    /* (Bawaan dari 'inline-flex', jaga agar tetap ada) */
            justify-content: space-between; /* (Bawaan dari 'inline-flex', jaga agar tetap ada) */
            
            vertical-align: top;     /* 2. Jaga agar sejajar di atas */
            margin: 4mm;             /* 3. Beri jarak aman (2 kartu = 186mm, pas di 190mm) */
            text-align: left;        /* 4. Kembalikan perataan teks di dalam kartu */
            
            /* --- INI KUNCI AGAR TIDAK TERPOTONG --- */
            page-break-inside: avoid; /* 5. TETAP PERTAHANKAN INI! */
        }
        /* --- AKHIR PERUBAHAN --- */

        .card-header h3 {
            margin: 0;
            font-size: 12pt;
            text-align: center;
            border-bottom: 1px solid #ccc;
            padding-bottom: 5px;
            margin-bottom: 10px;
        }
        .card-body p {
            margin: 5px 0;
            font-size: 10pt;
        }
        .card-body strong {
            display: inline-block;
            width: 50px;
        }
        .card-pin {
            text-align: center;
            background-color: #efefef;
            padding: 8px;
            border-radius: 4px;
            margin-top: 10px;
        }
        .print-button {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 10px 20px;
            background-color: #0d6efd;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }

        /* Print specific styles */
        @media print {
            body {
                padding: 0; /* @page sudah mengatur margin */
                background-color: white;
            }
            .print-button {
                display: none; 
            }
            .card {
                border: 1px dashed #999;
            }
            .page-container:last-child {
                page-break-after: auto;
            }
        }
    </style>
</head>
<body>

    <button onclick="window.print()" class="print-button">Cetak</button>

    <div class="page-container">
        @forelse ($voters as $voter)
            <div class="card">
                <div class="card-header">
                    <h3>KARTU PEMILIH OSIS</h3>
                </div>
                <div class="card-body">
                    <p><strong>Nama</strong>: {{ $voter['name'] }}</p>
                    <p><strong>Kelas</strong>: {{ $voter['class'] }}</p>
                    <p><strong>NIS</strong>: {{ $voter['nis'] }}</p>
                </div>
                <div class="card-pin">
                    <span>{{ $voter['pin'] }}</span>
                </div>
            </div>
        @empty
            <p>Tidak ada data untuk ditampilkan.</p>
        @endforelse
    </div>

</body>
</html>