@extends('layouts.app')
@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 p-4">
  <div class="max-w-7xl mx-auto">
    <div class="mb-8">
      <div class="flex items-center justify-between">
        <div>
          <h1 class="text-4xl font-bold bg-gradient-to-r from-blue-600 to-indigo-600 bg-clip-text text-transparent mb-2">
            Manajemen Pemilih
          </h1>
          <p class="text-slate-600">Kelola data pemilih dan PIN akses</p>
        </div>
        <div class="flex items-center gap-3">
          <div class="bg-white rounded-full px-4 py-2 shadow-sm border">
            <span class="text-sm text-slate-600">Total: </span>
            <span class="font-bold text-blue-600">{{ $voters->total() }}</span>
          </div>
          <a href="{{ route('admin.voters.create') }}"
             class="hidden sm:inline-flex bg-gradient-to-r from-emerald-500 to-teal-600 hover:from-emerald-600 hover:to-teal-700 text-white px-4 py-2 rounded-lg font-medium transition-all duration-200">
            + Tambah Manual
          </a>
        </div>
      </div>
    </div>

    @if(session('error'))
    <div class="mb-6 p-4 bg-red-50 border-l-4 border-red-500 rounded-r-lg animate-fade-in">
      <div class="flex items-center">
        <svg class="w-5 h-5 text-red-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
          <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
        </svg>
        <span class="text-red-700 font-medium">{{ session('error') }}</span>
      </div>
    </div>
    @endif

    @if(session('status'))
    <div class="mb-6 p-4 bg-green-50 border-l-4 border-green-500 rounded-r-lg animate-fade-in">
      <div class="flex items-start">
        <svg class="w-5 h-5 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
          <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
        </svg>
        <div>
          <span class="text-green-700 font-medium">{{ session('status') }}</span>
          
          {{-- Tombol Unduh & Cetak akan muncul di sini jika ada data PIN di session --}}
          @if (session()->has('generated_pins'))
              <div class="mt-3 flex flex-wrap gap-3">
                  <a href="{{ route('admin.voters.downloadPins') }}" class="inline-flex items-center bg-white border border-slate-300 hover:border-slate-400 text-slate-700 px-4 py-2 rounded-lg font-medium transition-all duration-200 text-sm">
                      <svg class="w-4 h-4 inline mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M3 17a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm3.293-7.707a1 1 0 011.414 0L9 10.586V3a1 1 0 112 0v7.586l1.293-1.293a1 1 0 111.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd"/>
                      </svg>
                      Unduh PIN (.csv)
                  </a>
                  <a href="{{ route('admin.voters.printCards') }}" target="_blank" class="inline-flex items-center bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-medium transition-all duration-200 text-sm">
                      <svg class="w-4 h-4 inline mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M5 4a2 2 0 012-2h6a2 2 0 012 2v1h-2V4H7v1H5V4zM3 7a2 2 0 012-2h10a2 2 0 012 2v5a2 2 0 01-2 2h-2v2a2 2 0 01-2 2H7a2 2 0 01-2-2v-2H3V7zm3 4a1 1 0 011-1h6a1 1 0 110 2H9a1 1 0 01-1-1z" />
                      </svg>
                      Cetak Kartu
                  </a>
              </div>
          @endif
        </div>
      </div>
    </div>
    @endif
    <div class="grid lg:grid-cols-3 gap-6 mb-8">
      <div class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden group hover:shadow-xl transition-all duration-300">
        <div class="bg-gradient-to-r from-blue-500 to-indigo-600 p-6 text-white">
          <div class="flex items-center justify-between">
            <div>
              <h3 class="text-lg font-semibold mb-1">Periode Aktif</h3>
              <p class="text-blue-100 text-sm">Status pemilihan</p>
            </div>
            <div class="bg-white/20 p-3 rounded-full">
              <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd"/>
              </svg>
            </div>
          </div>
        </div>
        <div class="p-6">
          <p class="text-xl font-bold text-slate-800 mb-2">{{ $period->name ?? 'Tidak ada periode aktif' }}</p>
          <div class="flex items-center text-sm text-slate-600 mb-4">
            <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M18 8A6 6 0 006 8v4.586l-2.293-2.293a1 1 0 00-1.414 1.414l4 4a1 1 0 001.414 0l4-4a1 1 0 00-1.414-1.414L8 12.586V8a4 4 0 118 0v5a2 2 0 11-4 0V8a6 6 0 012 11.472" clip-rule="evenodd"/>
            </svg>
            <span>PIN terbit: <strong>{{ $withPin }}</strong></span>
          </div>
          <div class="flex flex-wrap gap-2">
            <form method="POST" action="{{ route('admin.voters.generatePins') }}" class="flex-1 min-w-0">
              @csrf
              <button class="w-full bg-gradient-to-r from-green-500 to-emerald-600 hover:from-green-600 hover:to-emerald-700 text-white px-4 py-2 rounded-lg font-medium transition-all duration-200 transform hover:scale-[1.02] hover:shadow-lg text-sm" 
                       onclick="return confirm('APAKAH ANDA YAKIN?\nTindakan ini akan membuat PIN BARU untuk SEMUA pemilih aktif.\nPIN lama yang mungkin sudah dibagikan akan hangus dan tidak berlaku lagi.')">
                <svg class="w-4 h-4 inline mr-2" fill="currentColor" viewBox="0 0 20 20">
                  <path fill-rule="evenodd" d="M4 2a1 1 0 011 1v2.101a7.002 7.002 0 0111.601 2.566 1 1 0 11-1.885.666A5.002 5.002 0 005.999 7H9a1 1 0 010 2H4a1 1 0 01-1-1V3a1 1 0 011-1zm.008 9.057a1 1 0 011.276.61A5.002 5.002 0 0014.001 13H11a1 1 0 110-2h5a1 1 0 011 1v5a1 1 0 11-2 0v-2.101a7.002 7.002 0 01-11.601-2.566 1 1 0 01.61-1.276z" clip-rule="evenodd"/>
                </svg>
                Generate PIN Massal
              </button>
            </form>
          </div>
        </div>
      </div>

      <div class="lg:col-span-2 bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden group hover:shadow-xl transition-all duration-300">
        <div class="bg-gradient-to-r from-purple-500 to-pink-600 p-6 text-white">
          <div class="flex items-center justify-between">
            <div>
              <h3 class="text-lg font-semibold mb-1">Import Data Pemilih</h3>
              <p class="text-purple-100 text-sm">Upload file CSV dengan format yang benar</p>
            </div>
            <div class="bg-white/20 p-3 rounded-full">
              <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M3 4a1 1 0 011-1h4a1 1 0 010 2H6.414l2.293 2.293a1 1 0 01-1.414 1.414L5 6.414V8a1 1 0 01-2 0V4zm9 1a1 1 0 010-2h4a1 1 0 011 1v4a1 1 0 01-2 0V6.414l-2.293 2.293a1 1 0 11-1.414-1.414L13.586 5H12zm-9 7a1 1 0 012 0v1.586l2.293-2.293a1 1 0 111.414 1.414L6.414 15H8a1 1 0 010 2H4a1 1 0 01-1-1v-4zm13-1a1 1 0 011 1v4a1 1 0 01-1 1h-4a1 1 0 010-2h1.586l-2.293-2.293a1 1 0 111.414-1.414L15 13.586V12a1 1 0 011-1z" clip-rule="evenodd"/>
              </svg>
            </div>
          </div>
        </div>
        <div class="p-6">
          <div class="bg-slate-50 rounded-lg p-4 mb-4 border border-slate-200">
            <p class="text-sm font-medium text-slate-700 mb-2">Format Header CSV:</p>
            <code class="bg-slate-800 text-green-400 px-3 py-1 rounded-md text-sm font-mono">nis,name,class</code>
          </div>
          
          <form method="POST" action="{{ route('admin.voters.import') }}" enctype="multipart/form-data" class="space-y-4">
            @csrf
            <div class="flex flex-col md:flex-row gap-4">
              <div class="flex-1">
                <input type="file" name="csv" aaccept=".xlsx,.xls,.csv" 
                       class="block w-full text-sm text-slate-500 file:mr-4 file:py-3 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 transition-all duration-200 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" 
                       required>
              </div>
              <div class="flex gap-3">
                <button class="bg-gradient-to-r from-blue-500 to-indigo-600 hover:from-blue-600 hover:to-indigo-700 text-white px-6 py-3 rounded-lg font-medium transition-all duration-200 transform hover:scale-[1.02] hover:shadow-lg whitespace-nowrap">
                  <svg class="w-4 h-4 inline mr-2" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M3 17a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM6.293 6.707a1 1 0 010-1.414l3-3a1 1 0 011.414 0l3 3a1 1 0 01-1.414 1.414L11 5.414V13a1 1 0 11-2 0V5.414L7.707 6.707a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
                  </svg>
                  Upload CSV
                </button>
              </div>
            </div>
          </form>
          <div class="mt-4">
            <form action="{{ route('admin.voters.destroyAll') }}" method="POST" style="display: inline-block;">
              @csrf
              @method('DELETE')
              
              <button type="submit" 
                      {{-- Ganti class="btn btn-danger" DENGAN TAILWIND --}}
                      class="bg-gradient-to-r from-red-500 to-rose-600 hover:from-red-600 hover:to-rose-700 text-white px-6 py-3 rounded-lg font-medium transition-all duration-200"
                      onclick="return confirm('PERINGATAN! Ini akan menghapus SELURUH data pemilih dan semua PIN terkait. Tindakan ini tidak dapat diurungkan. Apakah Anda benar-benar yakin?');">
                  Hapus Semua Pemilih
              </button>
            </form>
        </div>
        </div>
      </div>
    </div>

    <div class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden">
      <div class="bg-gradient-to-r from-slate-800 to-slate-900 p-6 text-white">
        <div class="flex items-center justify-between">
          <div>
            <h3 class="text-lg font-semibold mb-1">Daftar Pemilih</h3>
            <p class="text-slate-300 text-sm">Data pemilih terdaftar dalam sistem</p>
          </div>
          <div class="bg-white/10 p-3 rounded-full">
            <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
              <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
          </div>
        </div>
      </div>
      <div class="p-6">
    <form method="GET" action="{{ route('admin.voters.index') }}">
      <div class="relative">
        <input type="text" name="search" placeholder="Cari berdasarkan Nama atau NIS..."
               value="{{ $search ?? '' }}"
               class="w-full pl-10 pr-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">
        <div class="absolute top-0 left-0 inline-flex items-center justify-center h-full w-12 text-slate-400">
          <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
        </div>
      </div>
    </form>
  </div>
      <div class="overflow-x-auto">
        <table class="w-full">
          <thead class="bg-slate-50 border-b border-slate-200">
            <tr>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">NIS</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Nama</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Kelas</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Status</th>
              <th class="px-6 py-4 text-right text-xs font-semibold text-slate-600 uppercase tracking-wider">Aksi</th>
            </tr>
          </thead>
          <tbody class="divide-y divide-slate-200">
            @forelse($voters as $v)
            <tr class="hover:bg-slate-50 transition-colors duration-150">
              <td class="px-6 py-4 whitespace-nowrap">
                <span class="bg-slate-100 text-slate-800 px-3 py-1 rounded-full text-sm font-mono">{{ $v->nis }}</span>
              </td>
              <td class="px-6 py-4 whitespace-nowrap">
                <div class="font-medium text-slate-900">{{ $v->name }}</div>
              </td>
              <td class="px-6 py-4 whitespace-nowrap">
                <span class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-sm font-medium">{{ $v->class }}</span>
              </td>
              <td class="px-6 py-4 whitespace-nowrap">
                @if($v->is_active)
                  <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                      <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                    </svg>
                    Aktif
                  </span>
                @else
                  <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-gray-100 text-gray-600">
                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                      <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                    </svg>
                    Tidak Aktif
                  </span>
                @endif
              </td>
              <td class="px-6 py-4 whitespace-nowrap">
                <div class="flex justify-end gap-2">
                  <a href="{{ route('admin.voters.edit',$v) }}"
                     class="px-3 py-1.5 rounded-lg text-xs font-medium bg-white border border-slate-300 hover:border-blue-400 hover:text-blue-600 transition-all">
                    Edit
                  </a>

                  <form method="POST" action="{{ route('admin.voters.generatePinForOne',$v) }}"
                        onsubmit="return confirm('Terbitkan PIN untuk {{ $v->name }}?')">
                    @csrf
                    <button class="px-3 py-1.5 rounded-lg text-xs font-medium bg-white border border-emerald-300 hover:border-emerald-500 hover:text-emerald-600 transition-all">
                      PIN
                    </button>
                  </form>

                  <form method="POST" action="{{ route('admin.voters.destroy',$v) }}"
                        onsubmit="return confirm('Hapus pemilih {{ $v->name }}? Tindakan ini tidak bisa dibatalkan.')">
                    @csrf @method('DELETE')
                    <button class="px-3 py-1.5 rounded-lg text-xs font-medium bg-white border border-rose-300 hover:border-rose-500 hover:text-rose-600 transition-all">
                      Hapus
                    </button>
                  </form>
                </div>
              </td>
            </tr>
            @empty
            <tr>
              <td colspan="5" class="px-6 py-8">
                <div class="text-center text-slate-500">Belum ada data pemilih.</div>
              </td>
            </tr>
            @endforelse
          </tbody>
        </table>
      </div>
      
      <div class="bg-slate-50 px-6 py-4 border-t border-slate-200">
        {{ $voters->links() }}
      </div>
    </div>
  </div>
</div>

<style>
@keyframes fade-in {
  from { opacity: 0; transform: translateY(-10px); }
  to { opacity: 1; transform: translateY(0); }
}
.animate-fade-in { animation: fade-in 0.3s ease-out; }
</style>
@endsection