@extends('layouts.app')
@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100">
  <div class="max-w-5xl mx-auto px-4 py-8">
    
    <!-- Header Section -->
    <div class="mb-8">
      <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4 mb-6">
        <div class="space-y-2">
          <div class="flex items-center gap-3">
            <div class="w-10 h-10 bg-gradient-to-r from-blue-500 to-indigo-600 rounded-xl flex items-center justify-center">
              <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
              </svg>
            </div>
            <h1 class="text-4xl lg:text-5xl font-bold bg-gradient-to-r from-blue-600 via-indigo-600 to-purple-600 bg-clip-text text-transparent">
              Edit Kandidat
            </h1>
          </div>
          <div class="flex items-center gap-2 text-slate-600">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
            </svg>
            <span class="font-semibold text-slate-800">{{ $candidate->name }}</span>
            @if($candidate->class)
              <span class="text-slate-400">•</span>
              <span>{{ $candidate->class }}</span>
            @endif
          </div>
        </div>
        
        <a href="{{ route('admin.candidates.index') }}" 
           class="inline-flex items-center gap-2 px-5 py-2.5 bg-white/80 backdrop-blur-sm border border-slate-200 hover:border-slate-300 text-slate-700 hover:text-slate-900 rounded-xl font-medium transition-all duration-200 shadow-sm hover:shadow">
          <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
          </svg>
          Kembali
        </a>
      </div>

      <!-- Breadcrumb -->
      <nav class="flex items-center gap-2 text-sm text-slate-500">
        <a href="{{ route('admin.candidates.index') }}" class="hover:text-blue-600 transition-colors">Manajemen Kandidat</a>
        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
        </svg>
        <span class="text-slate-700 font-medium">Edit: {{ $candidate->name }}</span>
      </nav>
    </div>

    <!-- Error Messages -->
    @if ($errors->any())
      <div class="mb-8 p-5 bg-gradient-to-r from-red-50 to-rose-50 border-l-4 border-red-500 rounded-r-xl shadow-sm">
        <div class="flex items-start gap-3">
          <svg class="w-5 h-5 text-red-600 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.732-.833-2.5 0L4.268 19.5c-.77.833.192 2.5 1.732 2.5z"/>
          </svg>
          <div>
            <h3 class="font-semibold text-red-800 mb-2">Terdapat kesalahan pada form:</h3>
            <ul class="space-y-1">
              @foreach ($errors->all() as $e)
                <li class="flex items-start gap-2 text-red-700">
                  <span class="w-1.5 h-1.5 bg-red-400 rounded-full mt-2 flex-shrink-0"></span>
                  <span>{{ $e }}</span>
                </li>
              @endforeach
            </ul>
          </div>
        </div>
      </div>
    @endif

    <!-- Form Container -->
    <div class="bg-white/80 backdrop-blur-sm border border-white/50 rounded-2xl shadow-xl overflow-hidden">
      
      <!-- Form Header -->
      <div class="bg-gradient-to-r from-blue-50 to-indigo-50 px-8 py-6 border-b border-slate-200">
        <h2 class="text-xl font-semibold text-slate-800 flex items-center gap-2">
          <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
          </svg>
          Update Data Kandidat
        </h2>
        <p class="text-slate-600 mt-1">Perbarui informasi kandidat dengan data yang akurat</p>
      </div>

      <!-- Form Content -->
      <form method="POST" action="{{ route('admin.candidates.update',$candidate) }}" enctype="multipart/form-data" class="p-8">
        @csrf @method('PUT')
        
        <div class="space-y-8">
          
          <!-- Basic Information Section -->
          <div class="space-y-6">
            <div class="flex items-center gap-3 pb-3 border-b border-slate-200">
              <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                </svg>
              </div>
              <h3 class="text-lg font-semibold text-slate-800">Informasi Dasar</h3>
            </div>
            
            <div class="grid md:grid-cols-2 gap-6">
              <div class="space-y-2">
                <label class="block text-sm font-semibold text-slate-700">
                  Nama Lengkap <span class="text-red-500">*</span>
                </label>
                <div class="relative">
                  <input name="name" type="text" 
                         class="w-full px-4 py-3 bg-white border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all" 
                         placeholder="Masukkan nama lengkap kandidat"
                         value="{{ old('name',$candidate->name) }}" required>
                  <svg class="absolute right-3 top-1/2 transform -translate-y-1/2 w-5 h-5 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                  </svg>
                </div>
              </div>

              <div class="space-y-2">
                <label class="block text-sm font-semibold text-slate-700">Kelas</label>
                <div class="relative">
                  <input name="class" type="text" 
                         class="w-full px-4 py-3 bg-white border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all" 
                         placeholder="contoh: XII IPA 1"
                         value="{{ old('class',$candidate->class) }}">
                  <svg class="absolute right-3 top-1/2 transform -translate-y-1/2 w-5 h-5 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-4m-5 0H3m2 0h4M9 7h6m-6 4h6m-2 4h2"/>
                  </svg>
                </div>
              </div>
            </div>
          </div>

          <!-- Photo Section -->
          <div class="space-y-6">
            <div class="flex items-center gap-3 pb-3 border-b border-slate-200">
              <div class="w-8 h-8 bg-emerald-100 rounded-lg flex items-center justify-center">
                <svg class="w-5 h-5 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                </svg>
              </div>
              <h3 class="text-lg font-semibold text-slate-800">Foto Kandidat</h3>
            </div>

            <div class="grid lg:grid-cols-2 gap-6">
              <!-- Current Photo -->
              <div class="space-y-3">
                <label class="block text-sm font-semibold text-slate-700">Foto Saat Ini</label>
                <div class="aspect-[4/3] bg-gradient-to-br from-slate-100 to-slate-200 rounded-2xl overflow-hidden border-2 border-slate-200 relative group">
                  @if($candidate->photo_url)
                    <img src="{{ $candidate->photo_url }}" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300" alt="{{ $candidate->name }}">
                    <div class="absolute inset-0 bg-black/0 group-hover:bg-black/10 transition-colors duration-300"></div>
                  @else
                    <div class="w-full h-full flex flex-col items-center justify-center text-slate-400">
                      <svg class="w-16 h-16 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                      </svg>
                      <span class="text-sm">Tidak ada foto</span>
                    </div>
                  @endif
                </div>
              </div>

              <!-- Upload New Photo -->
              <div class="space-y-3">
                <label class="block text-sm font-semibold text-slate-700">
                  Update Foto <span class="text-slate-500 text-xs">(Opsional - JPG/PNG, maksimal 2MB)</span>
                </label>
                <div class="space-y-3">
                  <div class="relative">
                    <input type="file" name="photo" accept="image/*" 
                           class="w-full px-4 py-3 bg-white border-2 border-dashed border-slate-200 rounded-xl text-slate-600 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-medium file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">
                  </div>
                  <div class="bg-blue-50 rounded-lg p-3 border border-blue-200">
                    <div class="flex items-start gap-2">
                      <svg class="w-4 h-4 text-blue-600 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                      </svg>
                      <p class="text-xs text-blue-700">
                        Kosongkan jika tidak ingin mengganti foto. Foto baru akan mengganti foto yang ada sebelumnya.
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- Vision & Mission Section -->
          <div class="space-y-6">
            <div class="flex items-center gap-3 pb-3 border-b border-slate-200">
              <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center">
                <svg class="w-5 h-5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 15l-2 5L9 9l11 4-5 2zm0 0l5 5M7.188 2.239l.777 2.897M5.136 7.965l-2.898-.777M13.95 4.05l-2.122 2.122m-5.657 5.656l-2.12 2.122"/>
                </svg>
              </div>
              <h3 class="text-lg font-semibold text-slate-800">Visi & Misi</h3>
            </div>
            
            <div class="grid md:grid-cols-1 gap-6">
              <div class="space-y-2">
                <label class="block text-sm font-semibold text-slate-700">Visi Kandidat</label>
                <textarea name="vision" rows="4"
                          class="w-full px-4 py-3 bg-white border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all resize-none" 
                          placeholder="Tuliskan visi yang jelas dan inspiratif untuk OSIS...">{{ old('vision',$candidate->vision) }}</textarea>
              </div>

              <div class="space-y-2">
                <label class="block text-sm font-semibold text-slate-700">Misi Kandidat</label>
                <textarea name="mission" rows="5"
                          class="w-full px-4 py-3 bg-white border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all resize-none" 
                          placeholder="Deskripsikan program dan langkah konkret untuk mewujudkan visi...">{{ old('mission',$candidate->mission) }}</textarea>
              </div>
            </div>
          </div>

          <!-- Settings Section -->
          <div class="space-y-6">
            <div class="flex items-center gap-3 pb-3 border-b border-slate-200">
              <div class="w-8 h-8 bg-orange-100 rounded-lg flex items-center justify-center">
                <svg class="w-5 h-5 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                </svg>
              </div>
              <h3 class="text-lg font-semibold text-slate-800">Pengaturan</h3>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
              <div class="space-y-2">
                <label class="block text-sm font-semibold text-slate-700">Urutan Tampil</label>
                <div class="relative">
                  <input name="sort_order" type="number" min="0" 
                         value="{{ old('sort_order',$candidate->sort_order) }}"
                         class="w-full px-4 py-3 bg-white border border-slate-200 rounded-xl text-slate-900 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">
                  <svg class="absolute right-3 top-1/2 transform -translate-y-1/2 w-5 h-5 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16V4m0 0L3 8m4-4l4 4m6 0v12m0 0l4-4m-4 4l-4-4"/>
                  </svg>
                </div>
                <p class="text-xs text-slate-500">Semakin kecil angka, semakin awal ditampilkan</p>
              </div>

              <div class="space-y-2">
                <label class="block text-sm font-semibold text-slate-700">Status Kandidat</label>
                <div class="bg-slate-50 rounded-xl p-4 border border-slate-200">
                  <input type="hidden" name="is_active" value="0">
                  <label class="flex items-center gap-3 cursor-pointer">
                    <input type="checkbox" name="is_active" value="1" 
                           class="w-5 h-5 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 focus:ring-2" 
                           {{ old('is_active',$candidate->is_active) ? 'checked' : '' }}>
                    <div class="flex items-center gap-2">
                      <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                      </svg>
                      <span class="text-sm font-medium text-slate-700">Kandidat aktif dalam pemilihan</span>
                    </div>
                  </label>
                  <p class="mt-2 text-xs text-slate-500 pl-8">Hanya kandidat aktif yang akan tampil dalam pemilihan</p>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Form Actions -->
        <div class="flex flex-col sm:flex-row gap-3 pt-8 mt-8 border-t border-slate-200">
          <a href="{{ route('admin.candidates.index') }}" 
             class="flex-1 sm:flex-none px-6 py-3 bg-white border border-slate-200 hover:border-slate-300 text-slate-700 hover:text-slate-900 rounded-xl font-medium transition-all duration-200 text-center">
            <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
            </svg>
            Batal
          </a>
          <button type="submit" 
                  class="flex-1 px-6 py-3 bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white rounded-xl font-medium shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 transition-all duration-200">
            <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
            </svg>
            Simpan Perubahan
          </button>
        </div>
      </form>
    </div>
  </div>
</div>
@endsection