<?php

namespace Database\Seeders;

use App\Models\{Period,Voter,VoterCredential,Candidate};
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class InitSeeder extends Seeder
{
    public function run(): void
    {
        // Admin
        if (!User::where('email','admin@osis.test')->exists()) {
            User::create([
                'name' => 'Admin OSIS',
                'email'=> 'admin@osis.test',
                'password' => Hash::make('password'),
            ]);
        }

        // Periode
        $p = Period::create([
            'name' => 'OSIS 2025/2026',
            'voting_start' => now()->addMinutes(1),
            'voting_end' => now()->addDays(3),
            'is_active' => true,
        ]);

        // Kandidat contoh
        Candidate::insert([
            ['period_id'=>$p->id,'number'=>1,'name'=>'Alya','class'=>'XI IPA 1','is_verified'=>1],
            ['period_id'=>$p->id,'number'=>2,'name'=>'Bima','class'=>'XI IPS 2','is_verified'=>1],
        ]);

        // 3 pemilih contoh
        $voters = [
            ['nis'=>'1001','name'=>'Siti','class'=>'X-1'],
            ['nis'=>'1002','name'=>'Rudi','class'=>'X-2'],
            ['nis'=>'1003','name'=>'Dina','class'=>'X-3'],
        ];
        foreach ($voters as $v) {
            $vv = Voter::firstOrCreate(['nis'=>$v['nis']],$v);
            $cred = VoterCredential::firstOrCreate(
                ['voter_id'=>$vv->id,'period_id'=>$p->id],
                ['pin'=>'1234']
            );
        }
    }
}
