<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ballots', function (Blueprint $table) {
            // TAMBAHKAN BARIS INI
            $table->foreignId('candidate_id')->nullable()->after('voter_id')->constrained()->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ballots', function (Blueprint $table) {
            // TAMBAHKAN BARIS INI
            $table->dropForeign(['candidate_id']);
            $table->dropColumn('candidate_id');
        });
    }
};