<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('candidates', function (Blueprint $table) {
            if (!Schema::hasColumn('candidates', 'sort_order')) {
                $table->smallInteger('sort_order')->default(0)->after('mission');
            }
            if (!Schema::hasColumn('candidates', 'is_active')) {
                $table->boolean('is_active')->default(true)->after('sort_order');
            }
        });
    }

    public function down(): void
    {
        Schema::table('candidates', function (Blueprint $table) {
            if (Schema::hasColumn('candidates', 'is_active')) {
                $table->dropColumn('is_active');
            }
            if (Schema::hasColumn('candidates', 'sort_order')) {
                $table->dropColumn('sort_order');
            }
            if (!Schema::hasColumn('candidates','period_id')) {
                $table->foreignId('period_id')->nullable()->constrained()->cascadeOnDelete()->after('id');
            }
            if (!Schema::hasColumn('candidates','photo_path')) {
                $table->string('photo_path')->nullable()->after('class');
            }
            if (!Schema::hasColumn('candidates','vision')) {
                $table->text('vision')->nullable()->after('photo_path');
            }
            if (!Schema::hasColumn('candidates','mission')) {
                $table->text('mission')->nullable()->after('vision');
            }
        });
    }
};
