<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void {
    Schema::create('candidates', function (Blueprint $t) {
        $t->id();
        $t->foreignId('period_id')->constrained()->cascadeOnDelete();
        $t->unsignedInteger('number')->default(1); // nomor urut
        $t->string('name');
        $t->string('class')->nullable();
        $t->string('photo_path')->nullable();
        $t->text('vision')->nullable();
        $t->text('mission')->nullable();
        $t->boolean('is_verified')->default(false);
        $t->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('candidates');
    }
};
