<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Hash;

class VoterCredential extends Model
{
    protected $fillable = ['voter_id','period_id','pin','used_at','invalidated_at'];
    protected $casts = ['used_at'=>'datetime','invalidated_at'=>'datetime'];

    public function voter(): BelongsTo { return $this->belongsTo(Voter::class); }
    public function period(): BelongsTo { return $this->belongsTo(Period::class); }

    public function setPinAttribute($value) { $this->attributes['pin'] = Hash::make($value); }
    public function checkPin(string $plain): bool { return password_verify($plain, $this->pin); }
}
