<?php

namespace App\Http\Controllers;

use App\Models\Ballot;
use App\Models\Candidate;
use App\Models\Period;
use Illuminate\Http\Request;

class VoteController extends Controller
{
    public function index()
    {
        $periodId = session('period_id');
        $voterId  = session('voter_id');

        $period = Period::find($periodId);
        if (!$period) return redirect()->route('vote.login')->with('error','Periode tidak ditemukan.');

        // kalau sudah memilih, langsung ke thanks
        $already = Ballot::where('voter_id',$voterId)->where('period_id',$periodId)->exists();
        if ($already) return redirect()->route('vote.thanks');

        // tampilkan kandidat periode aktif (termasuk NULL jika ada data lama – opsional)
        $candidates = Candidate::where(function ($w) use ($periodId) {
                $w->where('period_id', $periodId)->orWhereNull('period_id');
            })
            ->where('is_active',1)
            ->orderBy('sort_order')->orderBy('name')->get();

        return view('voter.choose', compact('period','candidates'));
    }

    // app/Http/Controllers/VoteController.php

    public function store(Request $request)
    {
        $request->validate([
            'candidate_id' => 'required|integer|exists:candidates,id',
        ]);

        $periodId = (int) session('period_id');
        $voterId  = (int) session('voter_id');

        // Mencegah double vote (keamanan tambahan)
        $already = Ballot::where('voter_id', $voterId)->where('period_id', $periodId)->exists();
        if ($already) {
            // Jika sudah memilih, langsung logout dan arahkan ke halaman terima kasih
            session()->forget(['voter_id', 'period_id', 'voter_name']);
            return redirect()->route('vote.thanks')->with('info', 'Anda sudah memberikan suara sebelumnya.');
        }
        
        // PERUBAHAN DIMULAI DI SINI
        // Siapkan semua data yang akan disimpan, termasuk hash dan waktu
        $ballotData = [
            'voter_id'     => $voterId,
            'period_id'    => $periodId,
            'candidate_id' => (int)$request->candidate_id,
            'cast_at'      => now(), // Menyimpan waktu saat memilih
            'ip'           => $request->ip(), // Menyimpan alamat IP pemilih
            // Membuat hash unik sederhana dari ID pemilih, ID periode, dan waktu
            'hash'         => hash('sha256', $voterId . $periodId . microtime()), 
        ];

        // Simpan semua data ke database
        Ballot::create($ballotData);
        // PERUBAHAN SELESAI
        
        // Langsung logout setelah memilih
        session()->forget(['voter_id', 'period_id', 'voter_name']);

        return redirect()->route('vote.thanks')->with('status', 'Terima kasih, suara Anda telah direkam.');
    }

    public function thanks()
    {
        $period = Period::find(session('period_id'));
        return view('voter.thanks', compact('period'));
    }
}
